/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css1;

import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css1.Css1Style;
import org.w3c.css.properties.css1.CssFontCSS1;
import org.w3c.css.properties.css1.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssLength;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssValue;

public class CssLineHeightCSS1
extends CssProperty {
    private CssValue value;
    private static CssIdent normal = new CssIdent("normal");

    public CssLineHeightCSS1() {
        this.value = normal;
    }

    public CssLineHeightCSS1(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue val = expression.getValue();
        this.setByUser();
        if (val instanceof CssNumber || val instanceof CssLength || val instanceof CssPercentage) {
            float v = ((Number)val.get()).floatValue();
            if (v >= 0.0f) {
                this.value = val;
                expression.next();
                return;
            }
            throw new InvalidParamException("negative-value", Float.toString(v), ac);
        }
        if (inherit.equals(val)) {
            this.value = inherit;
            expression.next();
            return;
        }
        if (normal.equals(val)) {
            this.value = normal;
            expression.next();
            return;
        }
        throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
    }

    public CssLineHeightCSS1(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public Object get() {
        if (this.value == null) {
            return normal;
        }
        return this.value;
    }

    public String getPropertyName() {
        return "line-height";
    }

    public boolean isSoftlyInherited() {
        return this.value == inherit;
    }

    public String toString() {
        return this.value.toString();
    }

    public void addToStyle(ApplContext ac, CssStyle style) {
        CssFontCSS1 cssFont = ((Css1Style)style).cssFontCSS1;
        if (cssFont.lineHeight != null) {
            style.addRedefinitionWarning(ac, this);
        }
        cssFont.lineHeight = this;
    }

    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((Css1Style)style).getLineHeightCSS1();
        }
        return ((Css1Style)style).cssFontCSS1.lineHeight;
    }

    public boolean equals(CssProperty property) {
        return property instanceof CssLineHeightCSS1 && ((CssLineHeightCSS1)property).value == this.value;
    }

    public boolean isDefault() {
        return this.value == normal;
    }
}

